package gov.va.med.mhv.sm.api.transfer;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.http.client.utils.DateUtils;

@XmlRootElement(name = "Comment")
public class CommentTO implements Serializable {
	private static final long serialVersionUID = 4542914411612536570L;

	private Long id;
	private ClinicianUserTO user;
	private String text;
	private Date createdDate;

	public CommentTO() {
	}

	public CommentTO(String text) {
		this.text = text;
	}

	public CommentTO(Long id, ClinicianUserTO user, String text, Date createdDate) {
		this.id = id;
		this.user = user;
		this.text = text;
		this.createdDate = createdDate;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public ClinicianUserTO getUser() {
		return user;
	}
	public void setUser(ClinicianUserTO user) {
		this.user = user;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public String getCreatedDate() {
		return (createdDate!=null?DateUtils.formatDate(createdDate):"");
	}
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

}
